#!/bin/bash
######################################################################################
# Derek Demuro, this script is given as is, CopyLEFT                                 #
######################################################################################
######################################################################################
# README                              LEAME                                          #
######################################################################################
# This script will run and ping each server in the list domain or ip, and if error 
# mail will be sent to address.
#
############################To Set Up#################################################
#
# To set this script up, you'll need to add it to a cronjob to run on boot
# Most linux distros will allow a param @reboot /(path)/servermon.sh
# So... crontab -e
# At the bottom add: @reboot /(path)/servermon.sh
# REMEMBER TO ADD EXECUTABLE BIT TO THE FILE (777 Permissions)
######################################################################################
# SCRIPT CONFIGURATION                                                               #
######################################################################################
### List of servers to check connection with
readonly SERVERLIST='serverList.txt'
### Where should the log be saved?
readonly LOGNAME='servermonitor.log'
### Who should we mail?
readonly MAILTO='ddemuro@gmail.com'
### How many pings before we call it dead
readonly PINGCOUNT=2
### What is your local ip?
readonly LOCALIP='192.168.5.21'
### How much time between check's?
readonly SLEEPTIME=5
### How many records to keep
readonly CLEARLOGTMS=1000
######################################################################################
#################################FUNCTIONS START################################

###Function to clear the log
function clearLog() {
  echo 'Log cleared' > $LOGNAME
  echo 'Script will run ' $1 ' times then will clear itself'>> $LOGNAME
  return 0
}

#################################FUNCTIONS FINISH################################
#################################MAIN SCRIPT FUNC################################
while [ TRUE ]; do
    #add 1 to times
    times=`expr $times + 1`
    ##CLEAR THE LOG
    if [ $times -eq $CLEARLOGTMS ]; then
	clearlog
	$times=0
    fi
    
    ##Run script for every line in serverList
    cat $SERVERLIST | while read line
    do
	    # check if there are no blank lines
	    if [ ! -z $line ]; then
		    ping -c 2 $line > /dev/null
		    if [ "$?" -ne 0 ]; then 
			    echo -e "\e[00;31m`date +'%Y-%m-%d %H:%M:%S'` Something wrong with the server: $line\e[39m"
			    echo "`date +'%Y-%m-%d %H:%M:%S'` Server has gone DOWN!" | mail -s "Server $line is DOWN `date +'%Y-%m-%d %H:%M:%S'`" $MAILTO
			    # Or do send out mail
		    else
			    echo -e "\033[38;5;148m`date +'%Y-%m-%d %H:%M:%S'` All good: $line\033[39m"
		    fi
	    fi
    done
  ##We sleep till new run
  sleep $SLEEPTIME
done